<?php
// Datu bāzes pievienošanas informācija
$servername = "eraecho";  // Servera nosaukums (datubāzes serveris)
$username = "root";       // Datubāzes lietotājvārds
$password = "";           // Datubāzes parole
$dbname = "eraecho";      // Datubāzes nosaukums

// Savienošanās ar datubāzi, izmantojot MySQLi
$conn = new mysqli($servername, $username, $password, $dbname);

// Ja savienojums neizdodas, izvada kļūdu un pārtrauc izpildi
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

// Ja tiek saņemts POST pieprasījums, apstrādā pasūtījumu
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Saņem datus no formas
    $name = $_POST['name'];        // Vārds
    $email = $_POST['email'];      // E-pasts
    $address = $_POST['address'];  // Adrese
    $phone = $_POST['phone'];      // Telefona numurs
    
    // Definē pasūtījuma vērtības
    $subtotal = 235.00;  // Pasūtījuma apakšsuma (pamatcena)
    $tax = 18.80;        // Nodokļi
    $total = $subtotal + $tax;  // Kopējā summa (apakšsuma + nodokļi)

    // Sagatavo SQL vaicājumu, lai ievadītu pasūtījumu datubāzē
    $stmt = $conn->prepare("INSERT INTO orders (name, email, address, phone, subtotal, tax, total) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssddd", $name, $email, $address, $phone, $subtotal, $tax, $total);

    // Ja vaicājums tiek izpildīts veiksmīgi
    if ($stmt->execute()) {
        // Iegūst jaunā pasūtījuma ID
        $order_id = $stmt->insert_id;

        // Piemēra produkti, kas tiks pievienoti pasūtījumam (šos datus varētu saņemt arī no groza)
        $cart_items = [
            ['name' => 'Top 1', 'size' => 'M', 'price' => 45.00, 'quantity' => 1],
            ['name' => 'Denim 2', 'size' => 'L', 'price' => 95.00, 'quantity' => 2]
        ];

        // Ievada katru preču vienumu no groza tabulā
        foreach ($cart_items as $item) {
            $stmt = $conn->prepare("INSERT INTO cart_items (order_id, product_name, size, price, quantity) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("issdi", $order_id, $item['name'], $item['size'], $item['price'], $item['quantity']);
            $stmt->execute();  // Izpilda SQL vaicājumu
        }

        // Apstiprinājuma ziņojums
        echo "Order placed successfully!";
    } else {
        // Ja rodas kļūda vaicājuma izpildē, izvada kļūdas ziņojumu
        echo "Error: " . $stmt->error;
    }

    // Aizver sagatavoto vaicājumu
    $stmt->close();
    // Aizver savienojumu ar datubāzi
    $conn->close();
}
?>
